/*  Prüft die Einträge der Tabelle "scheduling.resource_timeline" vom Typ "off" auf logische Inkonsistenzen.
    Diese Funktion wird üblicherweise als Unterfunktion der DB-Funktion "scheduling.resource_timeline__validate_block" gerufen.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__validate_block_off', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__validate_block_off(
    _block scheduling.resource_timeline
) RETURNS jsonb AS $$
DECLARE
  _issues jsonb := '{ "has_issues": false, "issues":[] }';
BEGIN

    IF ( _block.ti_type <> 'off' ) THEN
        RAISE EXCEPTION 'invalid block type, id % is not of type off', _block.ti_id;
    END IF;

    IF ( _block.ti_usage <> 1 ) THEN
        _issues := jsonb_set( _issues, '{has_issues}', 'true' );
        _issues := jsonb_insert( _issues, '{ issues, 0 }', '"load not equal to 1"' );
    END IF;

    RETURN _issues;

END $$ language plpgsql;
